# Telegram Auto-Approval Bot

A powerful PHP bot to manage Telegram channel/group join requests with auto-approval, greeting/farewell messages, and admin panel features.

## Features

- **Auto-Approve** - Automatically approve join requests instantly or after a delay
- **Start Bot First** - Require users to start the bot before joining (enables broadcasts)
- **Greetings/Farewells** - Customizable welcome and goodbye messages with media & URL buttons
- **Admin Panel** - Full control via inline Telegram menus
- **Broadcast** - Send messages to all users or channels (batch processing)
- **Protection** - Language filters, RTL/Ideograph blocking (Groups & Channels), Link filter (Groups only), CAPTCHA
- **Force Subscribe** - Require users to join a channel (auto-fetches invite link)
- **Add Admin** - Owner can add new admins via the admin panel

## Requirements

- PHP 8.1+ with extensions: `mysqli`, `curl`, `mbstring`
- MySQL 5.7+ / MariaDB 10.3+
- Web Server with SSL (Apache/Nginx)

---

## 🚀 Quick Start (VPS)

**One-command installation:**

```bash
# Download and run installer
curl -sSL https://raw.githubusercontent.com/your-username/auto-request-approval/main/install.sh | sudo bash
```

Or manually:

```bash
git clone https://github.com/your-username/auto-request-approval.git /var/www/bot
cd /var/www/bot
sudo bash install.sh
```

The installer will:
- Install PHP 8.1, MySQL, Nginx, SSL
- Create database and configure `.env`
- Set up webhook and **Systemd service for cron**

**Update existing installation:**

```bash
cd /var/www/bot
sudo ./deploy.sh
```

---

## 📦 Client Deployment (Hostinger)

### Step 1: Upload Files

1. Log in to Hostinger Panel
2. Go to **File Manager** → `public_html/` (or subdomain folder)
3. Upload all files **EXCEPT**: `.env`, `vendor/`, `.git/`

### Step 2: Install Dependencies

SSH into your server (or use Hostinger Terminal):

```bash
cd public_html/your-folder
php composer.phar install --no-dev
```

### Step 3: Setup Database

1. Go to **Databases** → **MySQL Databases**
2. Create database: `telegram_bot`
3. Note the username, password, and host

### Step 4: Import Schema

1. Go to **Databases** → **phpMyAdmin**
2. Select your database
3. Click **Import** → Choose `schema_install.sql` → **Go**

### Step 5: Configure Environment

Create `.env` file via File Manager:

```ini
BOT_TOKEN=your_bot_token_here
DB_HOST=localhost
DB_USER=your_db_user
DB_PASS=your_db_password
DB_NAME=telegram_bot
ADMIN_IDS=your_user_id
OWNER_ID=your_user_id
LOG_LEVEL=error
```

Set permissions: `chmod 600 .env`

### Step 6: Set Webhook

Visit in browser:
```
https://api.telegram.org/bot<TOKEN>/setWebhook?url=https://yourdomain.com/webhook.php
```

### Step 7: Setup Cron Job

Go to **Advanced** → **Cron Jobs**, add:
```
* * * * * /usr/bin/php /home/user/public_html/cron.php
```

### Option 2: Robust Loop Script (Recommended for stability)

If your system cron stops working, use this script to keep it running:

1. Upload `run_cron.sh` to your folder.
2. Run in terminal:

```bash
# Make executable
chmod +x run_cron.sh

# Run in background (keeps running after you exit)
nohup ./run_cron.sh > logs/cron_runner.log 2>&1 &
```

To stop it:
```bash
pkill -f run_cron.sh
```

---

## Usage

1. Send `/start` to your bot on Telegram
2. Add the bot as admin to your channel
3. Configure settings via the inline menu

---

## Useful Commands

| Command | Description |
|---------|-------------|
| `sudo ./deploy.sh` | Update bot on VPS |
| `systemctl status bot-cron` | Check cron service status |
| `systemctl restart bot-cron` | Restart cron service |
| `tail -f logs/cron.log` | View cron logs |
| `sudo nano .env` | Edit configuration |
| `php set_webhook.php ...` | Set webhook manually |

---

## Security Notes

- `.env` file is excluded from Git via `.gitignore`
- Admin features restricted to `ADMIN_IDS` and `OWNER_ID`
- All database queries use prepared statements
- Set `.env` permissions to `600`

---

## Troubleshooting

**Bot not responding?**
```bash
# Check services
systemctl status nginx php8.1-fpm mysql

# Check logs
tail -f /var/log/nginx/error.log
tail -f logs/cron.log
```

**Database errors?**
- Verify `.env` credentials are correct
- Check MySQL is running: `systemctl status mysql`

**Cron not running?**
```bash
# For VPS (Installer):
systemctl status bot-cron

# For Manual/Shared Hosting:
crontab -l
```

---

## License

MIT License
