<?php

require_once __DIR__ . '/vendor/autoload.php';

use Dotenv\Dotenv;

// Load environment variables
$dotenv = Dotenv::createImmutable(__DIR__);
$dotenv->safeLoad();

return [
    'db_host'   => $_ENV['DB_HOST'] ?? 'localhost',
    'db_user'   => $_ENV['DB_USER'] ?? 'root',
    'db_pass'   => $_ENV['DB_PASS'] ?? '',
    'db_name'   => $_ENV['DB_NAME'] ?? 'telegram_bot',
    'bot_token' => $_ENV['BOT_TOKEN'] ?? '',
    'admins'    => explode(',', $_ENV['ADMIN_IDS'] ?? ''),
    'owner_id'  => (int)($_ENV['OWNER_ID'] ?? 0),
    'log_level' => $_ENV['LOG_LEVEL'] ?? 'error',
    // New Configs for Features
    'cron_secret' => $_ENV['CRON_SECRET'] ?? 'change_me_to_something_random',
    'site_url' => $_ENV['SITE_URL'] ?? 'http://localhost/auto-request-approval',
    'auto_reply_text' => $_ENV['AUTO_REPLY_TEXT'] ?? null,
];
