<?php
// Enable full error reporting immediately
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

echo "<h1>🤖 Hostinger Debugger</h1>";

// 1. Check PHP Version
echo "<h3>1. PHP Version Check</h3>";
echo "Current PHP Version: <b>" . phpversion() . "</b><br>";
if (version_compare(phpversion(), '8.1.0', '<')) {
    echo "<p style='color:red'>❌ <b>WARNING:</b> Your PHP version is too old! This bot requires PHP 8.1 or higher.<br>
    Please go to hPanel > Advanced > PHP Configuration and select PHP 8.1, 8.2 or 8.3.</p>";
} else {
    echo "<p style='color:green'>✅ PHP version is OK.</p>";
}

// 2. Check Vendor Directory
echo "<h3>2. Checking Project Files</h3>";
if (!file_exists(__DIR__ . '/vendor/autoload.php')) {
    die("<p style='color:red'>❌ <b>CRITICAL ERROR:</b> The <code>vendor</code> folder is missing!</p>
    <p>You did not upload the 'vendor' folder completely. This folder contains all the code libraries (Guzzle, Dotenv, etc) needed for the bot to run.</p>
    <p><b>Fix:</b> Upload the `vendor` folder from your PC to Hostinger.</p>");
}
echo "<p style='color:green'>✅ <code>vendor/autoload.php</code> found.</p>";

// 3. Test .env file
echo "<h3>3. Checking Environment Configuration</h3>";
if (!file_exists(__DIR__ . '/.env')) {
    die("<p style='color:red'>❌ <b>ERROR:</b> The <code>.env</code> file is missing!</p>
    <p>Did you rename <code>.env.example</code> to <code>.env</code>? Make sure the file exists in the file manager.</p>");
}
echo "<p style='color:green'>✅ <code>.env</code> file found.</p>";

// 4. Try Loading Libraries & Database
echo "<h3>4. Testing Database Connection</h3>";
try {
    require_once __DIR__ . '/vendor/autoload.php';
    
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__);
    $dotenv->load();
    echo "<p>✅ Libraries loaded & .env read successfully.</p>";
    
    $host = $_ENV['DB_HOST'] ?? 'localhost';
    $name = $_ENV['DB_NAME'] ?? '???';
    $user = $_ENV['DB_USER'] ?? '???';
    
    echo "Attempting to connect to:<br>";
    echo "Host: <code>$host</code><br>";
    echo "Database: <code>$name</code><br>";
    echo "User: <code>$user</code><br>";
    
    $dsn = "mysql:host={$host};dbname={$name};charset=utf8mb4";
    $pdo = new PDO($dsn, $user, $_ENV['DB_PASS'] ?? '');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2 style='color:green'>✅ SUCCESS! Database Connected.</h2>";
    echo "<p>If you see this message, your server is configured correctly.</p>";
    echo "<p><b>Next Step:</b> Delete this <code>debug_hostinger.php</code> file and try using your bot again.</p>";
    
} catch (Throwable $e) {
    echo "<h2 style='color:red'>❌ Connection Failed</h2>";
    echo "<p><b>Error Message:</b> " . htmlspecialchars($e->getMessage()) . "</p>";
    echo "<p><b>Troubleshooting:</b><br>
    1. Check your Database Password in <code>.env</code>.<br>
    2. Check if Database user has permissions.<br>
    3. Make sure DB_HOST is 'localhost'.</p>";
}
