<?php
require_once __DIR__ . '/vendor/autoload.php';

use Bot\Database;

$config = require __DIR__ . '/config.php';
$db = new Database($config['db_host'], $config['db_user'], $config['db_pass'], $config['db_name']);

$chatId = -1002485025975;
echo "Checking messages for Chat ID: $chatId\n";

$msgs = $db->getChannelMessages($chatId, 'greeting');
echo "Found " . count($msgs) . " greeting messages.\n";

if (empty($msgs)) {
    echo "No greeting messages found! Debugging table content...\n";
    // Check if ANY messages exist for this chat
    $all = $db->conn->query("SELECT * FROM channel_messages WHERE chat_id = $chatId")->fetch_all(MYSQLI_ASSOC);
    echo "Total messages for this chat (any type): " . count($all) . "\n";
    print_r($all);
    
    // Check if chat exists in channels table
    $chan = $db->getChannel($chatId);
    if ($chan) {
        echo "Channel exists in DB: " . print_r($chan, true) . "\n";
    } else {    
        echo "Channel NOT found in DB!\n";
    }
} else {
    print_r($msgs);
}
