#!/bin/bash

# Configuration
CRON_SCRIPT="cron.php"
SLEEP_TIME=60

echo "Starting robust cron runner for $CRON_SCRIPT..."

while true; do
    # Run the PHP cron script
    echo "[$(date)] Running $CRON_SCRIPT..."
    php "$CRON_SCRIPT"
    
    # Check exit code
    if [ $? -ne 0 ]; then
        echo "[$(date)] WARNING: $CRON_SCRIPT exited with error."
    fi

    # Wait before next run
    echo "[$(date)] Sleeping for $SLEEP_TIME seconds..."
    sleep $SLEEP_TIME
done
