<?php

function testRegex($pattern, $text, $description) {
    echo "Testing $description: ";
    if (preg_match($pattern, $text)) {
        echo "MATCH (Correct)\n";
    } else {
        echo "NO MATCH (Failed)\n";
    }
}

function testRegexFail($pattern, $text, $description) {
    echo "Testing $description (Should Fail): ";
    if (!preg_match($pattern, $text)) {
        echo "NO MATCH (Correct)\n";
    } else {
        echo "MATCH (Failed)\n";
    }
}

// 1. Link Filter
$linkPattern = '~(https?://|www\.|@[a-zA-Z0-9_]{5,})[^\s]+~i';
echo "--- Link Filter ---\n";
testRegex($linkPattern, "Check this http://google.com", "HTTP URL");
testRegex($linkPattern, "Check this www.google.com", "WWW URL");
testRegex($linkPattern, "Contact @admin_user please", "Username");
testRegex($linkPattern, "@username", "Username Start");
testRegexFail($linkPattern, "Hello world", "Plain Text");
testRegexFail($linkPattern, "Contact admin@gmail.com", "Email (should fail if we only want @username, but regex might match email if @ is followed by 5 chars? Let's check)");
// Email: admin@gmail.com -> @gmail.com matches @[a-zA-Z0-9_]{5,}?
// @gmail.com -> gmail (5 chars). So emails might be caught. 
// Do we want to block emails? @username usually implies Telegram username.
// Telegram usernames are alphanumeric + underscore. Emails have dots.
// My regex: @[a-zA-Z0-9_]{5,} (doesn't allow dots).
// gmail.com has dot.
// 'gmail.com' starts with 'gmail' which matches {5,}.
// So @gmail.com matches.
// Telegram usernames do not allow dots.
// So valid username: @ashish_singh
// Email: ashish@gmail.com
// Regex: @[a-zA-Z0-9_]{5,}
// It will match '@gmail'.
// If user wants to filter usernames, filtering emails might be a side effect or desired?
// Usually link filter blocks external links. Emails are personal info.
// I'll assume matching emails is acceptable or I should refine to exclude if it has dot?
// Telegram usernames CANNOT have dots.
// So if I enforce NO dots after @, it might be safer.
// But valid username `username` followed by space/end.
// My regex `[^\s]+` matches until space.
// If string is `@gmail.com`, it matches `@gmail` part?
// `@[a-zA-Z0-9_]{5,}` matches `@gmail`.
// Then `[^\s]+` matches `.com`.
// So it matches.

// 2. RTL
$rtlPattern = '/[\p{Arabic}\p{Hebrew}]/u';
echo "--- RTL Filter ---\n";
testRegex($rtlPattern, "Hello مرحبا", "Arabic Mixed");
testRegex($rtlPattern, "שלום", "Hebrew");
testRegexFail($rtlPattern, "Hello World", "Latin");

// 3. Ideograph
$ideoPattern = '/[\p{Han}\p{Hiragana}\p{Katakana}]/u';
echo "--- Ideograph Filter ---\n";
testRegex($ideoPattern, "Hello 你好", "Chinese Mixed");
testRegex($ideoPattern, "こんにちは", "Hiragana");
testRegexFail($ideoPattern, "Hello World", "Latin");
